clear all
capture log close
program drop _all
set more off
snapshot erase _all

log using "..\Programs\Preparing US and UK Migrant Stock.log", replace

*** Preparing US and UK Migrant Stock.do
*** 8/17/2016

**************************************************************************
**************************************************************************
*** US Migrant Stock
**************************************************************************
**************************************************************************

*************************************
*** Prepare US migrant stock data
*************************************
import excel using "..\Input Data\Globalization Input Data.xlsx", clear sheet("US Migrant Stock via MPI") firstrow
desc, f

*** Check the trend
*twoway line  migrant_stock_pct year, xlabel(1850(10)2020, angle(45)) ylabel(0(2)20)

*** Save tempfile
keep year migrant_stock_pct
tempfile us_migrants
save `us_migrants'.dta, replace

**************************************************************************
**************************************************************************
*** UK Migrant Stock
**************************************************************************
**************************************************************************

*************************************
*** Prepare the 1851-2001 data
*** Note: The Irish are not counted as foreign-born up through 1921, but they are counted as foreign-born afterward.
*************************************
import excel using "..\Input Data\Globalization Input Data.xlsx", clear sheet("UK Migrant Stock 1851-2001") firstrow
desc, f

*** Keep only 1951-2001 (we have alternative data for 2004-2014)
keep if year <= 2001

*** Save tempfile
keep year migrant_stock_pct
tempfile uk_stock_1851_2001
save `uk_stock_1851_2001'.dta, replace

*************************************
*** Read in the 2004-2014 data
*************************************
import excel using "..\Input Data\Globalization Input Data.xlsx", clear sheet("UK Migrant Stock 2004-2014") firstrow

drop population 

*************************************
*** Combine 1851-2014 data
*************************************
append using `uk_stock_1851_2001'.dta
sort year 

*** Check the trend
*twoway (line migrant_stock_pct year if year <= 1931, lcolor(navy)) (line  migrant_stock_pct year if year >= 1951, lcolor(navy)), xlabel(1850(10)2020, angle(45)) ylabel(0(2)20)

**************************************************************************
**************************************************************************
*** Compare US and UK
**************************************************************************
**************************************************************************

*************************************
*** Combine data
*************************************
rename migrant_stock_pct migrant_stock_pct_uk
label variable migrant_stock_pct_uk "Migrants in UK (% Population)"

merge 1:1 year using `us_migrants'.dta, nogen 
rename migrant_stock_pct migrant_stock_pct_us
label variable migrant_stock_pct_us "Migrants in US (% Population)"

sort year

*************************************
*** Graph data
*************************************

twoway (line  migrant_stock_pct_us year, lwidth(thick)) ///
	(line migrant_stock_pct_uk year if year <= 1931, lcolor("192 0 26") lwidth(thick)) (line migrant_stock_pct_uk year if year >= 1951, lcolor( "192 0 26") lwidth(thick)) ///
	(scatter migrant_stock_pct_us migrant_stock_pct_uk year if year == ., msymbol(square square) mcolor("6 78 129"  "192 0 26")), ///
	ytitle("Migrant Stock (% Population)", color(gs6)) ytick(0(2)16, tlength(0)) ylabel(2(2)16, noticks) yscale(noline titlegap(2) ) ///
	xtitle("Year", color(gs6)) xlabel(1850(10)2020, angle(45) ) ///
	legend(cols(2) order(4 5) symysize(1) symxsize(1)) ///
	title("Migrant Stock, US versus UK, 1850-2014") plotregion(margin(zero)) 
graph export "../Graphs/US and UK Migrant Stock.png", as(png) replace 

*************************************
*** Save the data
*************************************
desc, f
save "US and UK Migrant Stock.dta", replace

log close
